
#include "types.h" //includes <windows.h>
#include "memorydc1.h"


LRESULT CALLBACK WndProc( HWND, UINT, WPARAM, LPARAM);


int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
	PSTR lpszCmdParam, int nCmdShow)
{
	static char szAppName[] = "HellowWin";
	HWND masterhwnd;
	MSG msg;
	WNDCLASSEX wndclass;

	if (!hPrevInstance)
	{
		wndclass.cbSize = sizeof(wndclass);
		wndclass.style = CS_HREDRAW | CS_VREDRAW;
		wndclass.lpfnWndProc = WndProc;
		wndclass.cbClsExtra = 0;
		wndclass.cbWndExtra = 0;
		wndclass.hInstance = hInstance;
		wndclass.hIcon = LoadIcon( NULL, IDI_QUESTION );
		wndclass.hCursor = LoadCursor( NULL, IDC_ARROW );
		wndclass.hbrBackground = GetStockObject( BLACK_BRUSH );
		wndclass.lpszMenuName = NULL;
		wndclass.lpszClassName = szAppName;
		wndclass.hIconSm = LoadIcon( NULL, IDI_QUESTION );
		RegisterClassEx (&wndclass);
	}

	masterhwnd = CreateWindowEx(
			WS_EX_OVERLAPPEDWINDOW, //fancy window style
			szAppName,		// window class name
		"Hello4. Move mouse, click left and right,press M,G,B,R. Resize. 8/15/97 Rudy Rucker",	// window caption
			WS_OVERLAPPEDWINDOW,		// window style
			CW_USEDEFAULT,				// initial x position
			CW_USEDEFAULT,				// initial y position
			CW_USEDEFAULT,				// initial x size
			CW_USEDEFAULT,				// initial y size
			NULL,					// parent window handle
			NULL,					// window menu handle
			hInstance,				// program instance handle
			NULL);					// creation parameters

	ShowWindow(masterhwnd, nCmdShow);
	UpdateWindow(masterhwnd);

	while ( GetMessage( &msg, NULL, 0, 0 ) )
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	return msg.wParam;
}

LRESULT CALLBACK WndProc( HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	static MemoryDC *pMemDC;
	HDC hdc;
	PAINTSTRUCT ps;
	static BOOL  movedrawflag = FALSE;
	static COLORREF textcolor = RGB(255, 0, 0);

	switch (message)
	{
		case WM_CREATE:
			pMemDC = new MemoryDC(hwnd, RGB(0,0,0)); //Black background
			SetBkMode(pMemDC->hdc(), TRANSPARENT);
			return 0;

		case WM_PAINT:
			hdc = BeginPaint(hwnd, &ps);
			pMemDC->CopyTo(hdc, ps.rcPaint);
			EndPaint(hwnd, &ps);
			return 0;

		case WM_LBUTTONDOWN:
			SetTextColor(pMemDC->hdc(), RGB(0, 255, 255));
			TextOut(pMemDC->hdc(), LOWORD (lParam), HIWORD (lParam), "Left!", 5);
			InvalidateRect(hwnd, NULL, FALSE);
			/*This sends a WM_PAINT message.  Putting a NULL as the second
			argument invalidates the whole windows, so that the ps.rcRect
			will be equal to the window.  The FALSE as the third argument
			says not to bother erasing the window.  You don't have to
			erase it because the whole invalid area is going to be overwritten
			by the pMemDC->CopyTo call.*/
			return 0;

		case WM_RBUTTONDOWN:
			SetTextColor(pMemDC->hdc(), RGB(255, 255, 0));
			TextOut(pMemDC->hdc(), LOWORD (lParam), HIWORD (lParam),
				"Right!", 6);
			InvalidateRect(hwnd, NULL, FALSE);
			return 0;

		case WM_MOUSEMOVE:
			if (movedrawflag)
			{
				SetTextColor(pMemDC->hdc(), textcolor);
				TextOut(pMemDC->hdc(), LOWORD (lParam), HIWORD (lParam),
					"Move!", 6);
				InvalidateRect(hwnd, NULL, FALSE);
			}
			return 0;

		case WM_CHAR:
			switch (wParam)
			{
				case 'm':
					movedrawflag ^= TRUE;
					break;
				case 'q':
					SendMessage( hwnd, WM_DESTROY, 0, 0L ); //Goes to WndProc.
					break;
				case 'x':
					//Clear out the bitmap
					pMemDC->Clear();
			//Invalidate client area and send WM_PAINT.   FALSE means you don't need to
			//clear the window because the cleared bitmap will bitblt it.
					InvalidateRect(hwnd, NULL, FALSE);
					break;
				case 'r':
					textcolor = RGB(255,0,0);
					break;
				case 'g':
					textcolor = RGB(0,255,0);
					break;
				case 'b':
					textcolor = RGB(0,0,255);
					break;
				default: //You type another character
					SetBkMode(pMemDC->hdc(), TRANSPARENT);
					SetTextColor(pMemDC->hdc(), RGB(255, 255, 255));
					POINT curpos;
					GetCursorPos(&curpos);
					ScreenToClient(hwnd, &curpos);
					char letter[1];
					letter[0] = wParam;
					TextOut(pMemDC->hdc(), curpos.x, curpos.y, letter, 1);
					InvalidateRect(hwnd, NULL, FALSE);
					break;
			}
			return 0;

		case WM_DESTROY:
			delete pMemDC;
			PostQuitMessage(0);
			return 0;
	}

	return DefWindowProc(hwnd, message, wParam, lParam);
}

